--  LUA script for GTA Map Viewer
--   2005 by Steve M.
--
--  simple camera flight (tracks*.dat), see scripting.txt


function lerp(a, b, t)  -- linear interpolation between 2 vectors
  v = {}
  v[1] = a[1] + (b[1] - a[1]) * t
  v[2] = a[2] + (b[2] - a[2]) * t
  v[3] = a[3] + (b[3] - a[3]) * t
  return v
end


s = GetGameDir()

if not s then

  Msg('You must have the SA map loaded.')

else

  --io.input(s..'data/Paths/tracks.dat')
  io.input(s..'data/Paths/tracks2.dat')
  --io.input(s..'data/Paths/tracks3.dat')
  --io.input(s..'data/Paths/tracks4.dat')

  -- get number of coordinates
  num = io.read('*n')
  io.read()

  p1 = {0, 0, 0}
  p2 = {0, 0, 0}
  p3 = {0, 0, 0}
  height = 1.5  -- z offset

  for i = 1, num do

    -- cache 3 points
    p1 = p2
    p2 = p3
    p3 = {io.read('*n'), io.read('*n'), io.read('*n')+height}
    io.read()

    if i > 2 then
      -- simple interpolation over 3 points in 10 steps
      for f = 0, 0.9, 0.1 do
        UpdateEngineTime()
        pos = lerp(p1, p2, f)
        target = lerp(p2, p3, f+0.1)
        SetCamera(3, pos[1], pos[2], pos[3], target[1], target[2], target[3])
        Render()
      end
    end

  end

  io.close(io.input())

end