/*
 * Decompiled with CFR 0.152.
 */
package thehambone.gtatools.gtasum.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import thehambone.gtatools.gtasum.gui.DropPanel;
import thehambone.gtatools.gtasum.gui.OutputPanel;

public class Window
extends JFrame {
    private static final String ABOUT_PAGE_TEXT = "GTASum allows you to quickly and easily update the checksum on any GTA III-era save file, which can be useful if you are editing gamesaves without a proper gamesave editor.";
    private static Window currentWindow;
    private DropPanel dropPanel;
    private OutputPanel outputPanel;
    private JSplitPane splitPane;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu viewMenu;
    private JMenu windowMenu;
    private JMenu helpMenu;
    private JMenuItem fileOpenMenuItem;
    private JMenuItem fileExitMenuItem;
    private JCheckBoxMenuItem viewShowOutputCheckBoxMenuItem;
    private JCheckBoxMenuItem windowAlwaysOnTopCheckBoxMenuItem;
    private JMenuItem helpAboutMenuItem;
    private JDialog aboutDialog;
    private int defaultSplitPaneDividerSize;
    private boolean hasOutputPanelBeenVisible = false;

    public static void createAndShowGUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            System.err.printf("[ERROR]: %s\n", sw.toString());
            JOptionPane.showMessageDialog(null, "An error has occured:\n\n" + ex.toString(), "Error", 0);
        }
        Window window = new Window(String.format("%s %s", "GTASum", "1.0.0"));
        System.out.printf("%s %s\n", "GTASum", "1.0.0");
        System.out.printf("Created by %s\n", "thehambone");
        Window.setCurrentWindow(window);
        window.setDefaultCloseOperation(3);
        window.pack();
        window.setLocationRelativeTo(null);
        window.setVisible(true);
    }

    public static Window getCurrentWindow() {
        return currentWindow;
    }

    public static void setCurrentWindow(Window window) {
        currentWindow = window;
    }

    public Window(String title) {
        super(title);
        this.initComponents();
        this.initMenuBar();
        this.initAboutDialog();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.dropPanel = new DropPanel();
        this.outputPanel = new OutputPanel();
        this.outputPanel.setVisible(false);
        this.splitPane = new JSplitPane(0, this.dropPanel, this.outputPanel);
        this.splitPane.setResizeWeight(0.75);
        this.defaultSplitPaneDividerSize = this.splitPane.getDividerSize();
        this.setOutputPanelVisible(false);
        this.add((Component)this.splitPane, "Center");
    }

    private void initMenuBar() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.viewMenu = new JMenu("View");
        this.windowMenu = new JMenu("Window");
        this.helpMenu = new JMenu("Help");
        this.fileOpenMenuItem = new JMenuItem("Open...");
        this.fileExitMenuItem = new JMenuItem("Exit");
        this.viewShowOutputCheckBoxMenuItem = new JCheckBoxMenuItem("Show Output");
        this.windowAlwaysOnTopCheckBoxMenuItem = new JCheckBoxMenuItem("Always On Top");
        this.helpAboutMenuItem = new JMenuItem("About");
        this.fileOpenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("GTA III-era Save Files (*.b)", "b");
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setDialogType(0);
                fileChooser.setFileSelectionMode(0);
                fileChooser.setMultiSelectionEnabled(true);
                fileChooser.setFileFilter(fileNameExtensionFilter);
                int option = fileChooser.showOpenDialog(Window.this.getContentPane());
                if (option != 0) {
                    return;
                }
                File[] fileList = fileChooser.getSelectedFiles();
                if (!Window.this.hasOutputPanelBeenVisible) {
                    Window.this.setOutputPanelVisible(true);
                }
                Window.this.dropPanel.importFiles(new ArrayList<File>(Arrays.asList(fileList)));
            }
        });
        this.fileExitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.dispose();
            }
        });
        this.viewShowOutputCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.setOutputPanelVisible(Window.this.viewShowOutputCheckBoxMenuItem.isSelected());
            }
        });
        this.windowAlwaysOnTopCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.setAlwaysOnTop(Window.this.windowAlwaysOnTopCheckBoxMenuItem.isSelected());
            }
        });
        this.helpAboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.aboutDialog.setModal(true);
                Window.this.aboutDialog.setLocationRelativeTo(Window.this.dropPanel);
                Window.this.aboutDialog.setVisible(true);
                Window.this.aboutDialog.setModal(false);
            }
        });
        this.fileOpenMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.fileMenu.add(this.fileOpenMenuItem);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.fileExitMenuItem);
        this.viewMenu.add(this.viewShowOutputCheckBoxMenuItem);
        this.windowMenu.add(this.windowAlwaysOnTopCheckBoxMenuItem);
        this.helpMenu.add(this.helpAboutMenuItem);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.windowMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    private void initAboutDialog() {
        this.aboutDialog = new JDialog((Frame)this, String.format("About %s", "GTASum"));
        this.aboutDialog.setLayout(new BorderLayout());
        this.aboutDialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.aboutDialog.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        topPanel.setLayout(new BorderLayout());
        JLabel titleLabel = new JLabel("GTASum");
        titleLabel.setFont(titleLabel.getFont().deriveFont(0, 18.0f));
        titleLabel.setHorizontalAlignment(0);
        JLabel versionLabel = new JLabel(String.format("Version %s (%s)", "1.0.0", "January 7, 2015"));
        versionLabel.setHorizontalAlignment(0);
        JPanel centerPanel = new JPanel();
        centerPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        centerPanel.setLayout(new BorderLayout());
        JLabel infoLabel = new JLabel();
        infoLabel.setText(String.format("<html><p style='width: 200px;'>%s</p></html>", ABOUT_PAGE_TEXT));
        infoLabel.setHorizontalAlignment(0);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        bottomPanel.setLayout(new BorderLayout());
        JLabel authorLabel = new JLabel(String.format("<html>Author: <a href='%s'>%s</a></html>", "http://gtaforums.com/user/907241-thehambone/", "thehambone"));
        authorLabel.setCursor(Cursor.getPredefinedCursor(12));
        authorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    Window.this.openURI(new URI("http://gtaforums.com/user/907241-thehambone/"));
                }
                catch (URISyntaxException ex) {
                    StringWriter sw = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sw));
                    System.err.printf("[ERROR]: %s\n", sw.toString());
                    JOptionPane.showMessageDialog(Window.this.dropPanel, "An error has occured:\n\n" + ex.toString(), "Error", 0);
                }
            }
        });
        JLabel contactLabel = new JLabel(String.format("<html>Bug reports go to <a href='mailto:%s'>%s</a></html>", "thehambone93@gmail.com", "thehambone93@gmail.com"));
        contactLabel.setCursor(Cursor.getPredefinedCursor(12));
        contactLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    Window.this.openURI(new URI(String.format("mailto:%s", "thehambone93@gmail.com")));
                }
                catch (URISyntaxException ex) {
                    StringWriter sw = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sw));
                    System.err.printf("[ERROR]: %s\n", sw.toString());
                    JOptionPane.showMessageDialog(Window.this.dropPanel, "An error has occured:\n\n" + ex.toString(), "Error", 0);
                }
            }
        });
        topPanel.add((Component)titleLabel, "North");
        topPanel.add((Component)versionLabel, "Center");
        centerPanel.add((Component)infoLabel, "Center");
        bottomPanel.add((Component)authorLabel, "North");
        bottomPanel.add((Component)contactLabel, "South");
        this.aboutDialog.add((Component)topPanel, "North");
        this.aboutDialog.add((Component)centerPanel, "Center");
        this.aboutDialog.add((Component)bottomPanel, "South");
        this.aboutDialog.pack();
    }

    private void openURI(URI uRI) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(uRI);
            }
            catch (IOException ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                System.err.printf("[ERROR]: %s\n", sw.toString());
                JOptionPane.showMessageDialog(this.dropPanel, "An error has occured:\n\n" + ex.toString(), "Error", 0);
            }
        }
    }

    public void setOutputPanelVisible(boolean isVisible) {
        if (this.viewShowOutputCheckBoxMenuItem != null) {
            this.viewShowOutputCheckBoxMenuItem.setSelected(isVisible);
        }
        this.outputPanel.setVisible(isVisible);
        if (isVisible) {
            this.hasOutputPanelBeenVisible = true;
            this.splitPane.setDividerSize(this.defaultSplitPaneDividerSize);
        } else {
            this.splitPane.setDividerSize(0);
        }
        this.splitPane.setDividerLocation(0.75);
    }

    public boolean hasOutputPanelBeenVisible() {
        return this.hasOutputPanelBeenVisible;
    }
}

