unit IdeLookup;

interface

uses Classes, SysUtils, IniFiles;//ComObj;

const
  // Characters
  TAB = #9;
  LF  = #10;
  CR  = #13;
  SP  = #32;

  // Sets
  LFCR   = [LF, CR];
  White  = [TAB, SP];
  Alpha  = ['A'..'Z'] + ['a'..'z'] + ['_'];
  Number = ['0'..'9'];
  AlphaNumeric = Alpha + Number;

type
  TIdeEntry = class
    Code: Word;
    Name: string;
  end;

  TIdeLookup = class
  protected
    FByCode: TList;
    FByName: TList;
  public
    constructor Create;
    destructor Destroy; override;

    procedure Load(Ide: TFileName);
    procedure Clear;

    function IndexOf(Name: string; Len: Integer): Integer;
  end;


implementation

function CompareNames(Item1, Item2: Pointer): Integer;
begin
  Result := CompareText(TIdeEntry(Item1).Name, TIdeEntry(Item2).Name);
end;

function CompareCode(Item1, Item2: Pointer): Integer;
begin
 //
end;



{ TIdeLookup }

constructor TIdeLookup.Create;
begin
  FByCode := TList.Create;
  FByName := TList.Create;
end;

destructor TIdeLookup.Destroy;
begin
  FByCode.Free;
  FByName.Free;
end;

procedure TIdeLookup.Load(Ide: TFileName);
var
  f: TextFile;
  s,tmp1,tmp2: string;
  P, Start, Len: Integer;
  ie: TIdeEntry;
  function GetNextToken: string;
  begin
    Result := '';
    Start := p;
    while (s[p] in AlphaNumeric) and (p <= Len) do
    begin
      Inc(p);
    end;
    if p > Start then
    begin
      Result := Copy(s, Start, p - Start);
    end;
  end;
begin
  AssignFile(f, Ide);
  ReSet(f);

  while not Eof(f) do
  begin
    ReadLn(f, s);
    Len := Length(s);

    if len = 0 then continue;

    p := 1;
    while (s[P] in White) and (P <= Len) do
      Inc(P);

    if P >= Len then Continue;
    if s[p] = '#' then Continue;
    if Pos(',', s) = 0 then Continue;

    tmp1 := Trim(GetNextToken);

    while (s[P] = ',') and (P <= Len) do
      Inc(P);

    if P >= Len then Continue;

    while (s[P] in White) and (P <= Len) do
      Inc(P);

    tmp2 := Trim(GetNextToken);
    ie := TIdeEntry.Create;
    ie.Code := StrToInt(tmp1);
    ie.Name := tmp2;
    FByName.Add(ie);
  end;
  CloseFile(f);

  FByName.Sort(@CompareNames);
end;

procedure TIdeLookup.Clear;
var
  i: Integer;
begin
  for i := 0 to FByCode.Count -1 do
  begin
    TIdeEntry(FByCode.List[i]).Free;
  end;
  FByCode.Clear;
  FByName.Clear;
end;

function TIdeLookup.IndexOf(Name: string; Len: Integer): Integer;
var
  first, mid, last, i,n: Integer;
begin
  first := 0;
  last := FByName.Count - 1;
  Result := -1;
  while first <= Last do
  begin
    mid := (first + last) div 2;
    i := CompareText(Name, TIdeEntry(FByName.Items[mid]).Name);
    if i = 0 then
    begin
      Result := TIdeEntry(FByName.Items[mid]).Code;
      Exit;
    end;
    if i < 0 then
      last := mid -1
    else
      first := mid + 1;
  end;
end;

end.

